/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexp;
import net.nooj4nlp.engine.helper.PenAttributes;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class Graph
implements Serializable {
    public static final long serialVersionUID = 1L;
    public String name = null;
    public Dimension size;
    public int fits;
    public int[] arrHei;
    public int[] arrWid;
    public int[] arrPosX;
    public int[] arrPosY;
    public String[] arrLabel;
    public int[][] arrChild;
    public ArrayList<ArrayList<Object>> extraParams;
    public HashMap<String, PenAttributes<Color, Float>> pen;
    public transient Grammar wholeGrammar;
    public transient ArrayList<Integer> hei;
    public transient ArrayList<Integer> wid;
    public transient ArrayList<String> label;
    public transient ArrayList<Integer> posX;
    public transient ArrayList<Integer> posY;
    public transient ArrayList<ArrayList<Integer>> child;
    public transient ArrayList<Boolean> selected;
    public transient ArrayList<Object> history;
    public transient ArrayList<Integer> widB;
    public transient int iHistory;
    public transient Color aColor;
    public transient Color cColor;
    public transient Color fColor;
    public transient Color vColor;
    public transient int e5;
    public transient int e10;
    public transient int e20;
    public transient int interline;
    public transient int vinterline;
    public transient int x;
    public transient int y;
    public transient float scale;
    public transient Font cfont;
    public transient Font ffont;
    public transient Font ofont;
    public transient Font vfont;
    public transient Font ifont;
    public transient int epsilonHei;
    public transient int epsilonWid;
    public transient int epsilonwidB;
    public transient Color tColor;
    public transient int nbofnodesmoved = 0;
    public transient int inodemoved = 0;
    public transient int nbofnodesdeleted = 0;
    public transient int inodedeleted = 0;
    public transient int nbofnodesconnected = 0;
    public transient int inodeconnected = 0;
    public transient boolean oneconnectionatleast = false;
    public transient boolean onedisconnectionatleast = false;
    public transient ArrayList<Boolean> inDebugNode;
    public transient ArrayList<Integer> inDebugConnection;
    public transient boolean debugInvisible = false;

    public Graph() {
        this.size = new Dimension(1047, 763);
        this.fits = 100;
        this.scale = 1.0f;
        this.vfont = null;
        this.ofont = null;
        this.ifont = null;
        this.ffont = null;
        this.cfont = null;
        this.tColor = Color.BLACK;
        this.label = new ArrayList();
        this.selected = new ArrayList();
        this.posX = new ArrayList();
        this.posY = new ArrayList();
        this.hei = new ArrayList();
        this.wid = new ArrayList();
        this.widB = new ArrayList();
        this.child = new ArrayList();
        this.pen = new HashMap();
        this.history = new ArrayList();
        this.iHistory = 0;
        this.inodemoved = -1;
        this.inodeconnected = -1;
    }

    public Graph(Dimension givenSize) {
        this.size = givenSize;
        this.fits = 100;
        this.scale = 1.0f;
        this.vfont = null;
        this.ofont = null;
        this.ifont = null;
        this.ffont = null;
        this.cfont = null;
        this.tColor = Color.BLACK;
        this.label = new ArrayList();
        this.selected = new ArrayList();
        this.posX = new ArrayList();
        this.posY = new ArrayList();
        this.hei = new ArrayList();
        this.wid = new ArrayList();
        this.widB = new ArrayList();
        this.child = new ArrayList();
        this.pen = new HashMap();
        this.history = new ArrayList();
        this.iHistory = 0;
        this.inodemoved = -1;
        this.inodeconnected = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Graph loadIntex(Grammar grm, String fullPath, String encodingCode, GramType gt) {
        File graphFile = new File(fullPath);
        if (!graphFile.exists()) {
            return null;
        }
        BufferedReader reader = null;
        Graph grf = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullPath), encodingCode));
            String line = "";
            line = reader.readLine();
            String sep = " ";
            String sep2 = ":";
            String[] fields = line.split(sep);
            if (fields[0].charAt(0) != '#') {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    Graph graph = null;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e2.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    }
                    return graph;
                }
                Graph e = null;
                return e;
            }
            grf = new Graph();
            grf.name = FilenameUtils.removeExtension(graphFile.getName());
            grf.wholeGrammar = grm;
            line = reader.readLine();
            while (true) {
                String fontType;
                String fontName;
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                if (line.charAt(0) == '#') break;
                fields = line.split(sep);
                if ("SIZE".equals(fields[0])) {
                    grf.size = new Dimension(Integer.parseInt(fields[1]), Integer.parseInt(fields[2]));
                } else if ("FONT".equals(fields[0])) {
                    line = line.substring(fields[0].length() + 1);
                    fields = line.split(sep2);
                    fontName = fields[0].trim();
                    fontType = fields[1].trim();
                    grm.iFontName = fontName;
                    if (fontType.charAt(0) == 'B') {
                        grm.iFontStyle = 1;
                        grm.iFontSize = Float.parseFloat(fontType.substring(1));
                    } else if (fontType.charAt(0) == 'I') {
                        grm.iFontStyle = 2;
                        grm.iFontSize = Float.parseFloat(fontType.substring(1));
                    } else {
                        grm.iFontStyle = 0;
                        grm.iFontSize = Float.parseFloat(fontType);
                    }
                } else if ("OFONT".equals(fields[0])) {
                    line = line.substring(fields[0].length() + 1);
                    fields = line.split(sep2);
                    fontName = fields[0].trim();
                    fontType = fields[1].trim();
                    grm.oFontName = fontName;
                    if (fontType.charAt(0) == 'B') {
                        grm.oFontStyle = 1;
                        grm.oFontSize = Float.parseFloat(fontType.substring(1));
                    } else if (fontType.charAt(0) == 'I') {
                        grm.oFontStyle = 2;
                        grm.oFontSize = Float.parseFloat(fontType.substring(1));
                    } else {
                        grm.oFontStyle = 0;
                        grm.oFontSize = Float.parseFloat(fontType);
                    }
                } else if ("ACOLOR".equals(fields[0])) {
                    grm.aColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("BCOLOR".equals(fields[0])) {
                    grm.bColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("CCOLOR".equals(fields[0])) {
                    grm.cColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("FCOLOR".equals(fields[0])) {
                    grm.fColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("SCOLOR".equals(fields[0])) {
                    grm.sColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("DBOXES".equals(fields[0])) {
                    grm.dispBox = fields[1].charAt(0) == 'y';
                } else if ("DFRAME".equals(fields[0])) {
                    grm.dispFrame = fields[1].charAt(0) == 'y';
                } else if ("DDATE".equals(fields[0])) {
                    grm.dispDate = fields[1].charAt(0) == 'y';
                } else if ("DDIR".equals(fields[0])) {
                    grm.dispDir = fields[1].charAt(0) == 'y';
                } else if ("DFILE".equals(fields[0])) {
                    grm.dispFile = fields[1].charAt(0) == 'y';
                } else if (!"DRIG".equals(fields[0])) {
                    if ("DRST".equals(fields[0])) {
                        grm.dispState = fields[1].charAt(0) == 'y';
                    } else if ("FITS".equals(fields[0])) {
                        grf.fits = Integer.parseInt(fields[1]);
                        if (grf.fits == 2) {
                            grf.fits = 1;
                        }
                    } else if (!"PORIENT".equals(fields[0])) {
                        Graph e2 = null;
                        return e2;
                    }
                }
                line = reader.readLine();
            }
            grm.cFontName = grm.iFontName;
            grm.cFontSize = grm.iFontSize;
            grm.cFontStyle = grm.iFontStyle;
            grm.vColor = Color.RED;
            line = reader.readLine();
            int nbOfNodes = Integer.parseInt(line);
            for (int iNode = 0; iNode < nbOfNodes; ++iNode) {
                line = reader.readLine();
                StringBuilder label = new StringBuilder();
                int isTrt = 0;
                while (line.charAt(isTrt) != '\"') {
                    ++isTrt;
                }
                ++isTrt;
                int length = 0;
                while (isTrt + length < line.length() && line.charAt(isTrt + length) != '\"') {
                    if (line.charAt(isTrt + length) == '\\') {
                        char character = line.charAt(isTrt + length + 1);
                        if (character == '+' || character == ':' || character == '<' || character == '/' || character == '\\') {
                            label.append('\\');
                            label.append(line.charAt(isTrt + length + 1));
                            length += 2;
                            continue;
                        }
                        label.append(line.charAt(isTrt + length + 1));
                        length += 2;
                        continue;
                    }
                    label.append(line.charAt(isTrt + length));
                    ++length;
                }
                if (isTrt + length >= line.length()) {
                    Graph character = null;
                    return character;
                }
                StringBuilder labelNooJ = Graph.convert(label, gt);
                grf.label.add(labelNooJ.toString());
                grf.selected.add(false);
                ++length;
                while (Character.isWhitespace(line.charAt(isTrt + length))) {
                    ++length;
                }
                String connections = line.substring(isTrt + length);
                fields = connections.split(sep);
                int x = 0;
                int y = 0;
                int n = 0;
                try {
                    x = Integer.parseInt(fields[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    y = Integer.parseInt(fields[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n = Integer.parseInt(fields[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                grf.posX.add(x);
                grf.posY.add(y);
                grf.hei.add(-1);
                grf.wid.add(-1);
                grf.widB.add(-1);
                int nbOfChildren = n;
                grf.child.add(new ArrayList());
                for (int iChild = 0; iChild < nbOfChildren; ++iChild) {
                    n = 0;
                    try {
                        n = Integer.parseInt(fields[iChild + 3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    grf.child.get(iNode).add(n);
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            Graph graph = null;
            return graph;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        return grf;
    }

    public boolean commentNode(int inode) {
        if (inode < 2) {
            return false;
        }
        String lbl = this.label.get(inode);
        if (lbl.length() == 0 || lbl.charAt(0) == ':') {
            return false;
        }
        ArrayList<Integer> children = this.child.get(inode);
        if (children.size() == 0) {
            return true;
        }
        for (int jnode = 0; jnode < this.child.size(); ++jnode) {
            children = this.child.get(jnode);
            for (int ic = 0; ic < children.size(); ++ic) {
                if (children.get(ic) != inode) continue;
                return false;
            }
        }
        return true;
    }

    public boolean areaNode(int inode) {
        if (inode < 2) {
            return false;
        }
        String lbl = this.label.get(inode);
        if (lbl.length() == 0 || lbl.charAt(0) != ':') {
            return false;
        }
        ArrayList<Integer> children = this.child.get(inode);
        if (children.size() > 0) {
            return false;
        }
        for (int jnode = 0; jnode < this.child.size(); ++jnode) {
            children = this.child.get(jnode);
            for (int ic = 0; ic < children.size(); ++ic) {
                if (children.get(ic) != inode) continue;
                return false;
            }
        }
        return true;
    }

    private boolean variableNode(int inode) {
        String lbl = this.label.get(inode);
        if (lbl == null || lbl.length() < 2) {
            return false;
        }
        if (lbl.charAt(0) != '$') {
            return false;
        }
        return lbl.charAt(1) == '(' || lbl.charAt(1) == ')';
    }

    private void drawConnection(int inode, int ilength, int iheight, int jheight, int jnode, Graphics2D g) {
        int destination;
        if (this.inDebugConnection != null && this.debugInvisible && inode < this.inDebugConnection.size() && jnode == (destination = this.inDebugConnection.get(inode).intValue())) {
            return;
        }
        int xi = this.x + ilength;
        int yi = this.y;
        int xj = (int)((float)this.posX.get(jnode).intValue() * this.scale);
        int yj = (int)((float)this.posY.get(jnode).intValue() * this.scale);
        g.setColor((Color)this.pen.get((Object)"penC").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"penC").stroke));
        if (xi <= xj) {
            g.drawLine(xi, yi, xj, yj);
            return;
        }
        if (yi - iheight >= yj + jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi + this.e10, yi - iheight - this.e10), new Point(xj - this.e10, yj + iheight + this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else if (yi + iheight <= yj - jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi + this.e10, yi + iheight + this.e10), new Point(xj - this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi + this.e10, yi - iheight - this.e10), new Point(xj - this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        }
    }

    private void drawLoop(int inode, Graphics2D g) {
        int xi = this.x + this.wid.get(inode);
        int radius = this.hei.get(inode) / 2 + this.e5;
        g.setColor((Color)this.pen.get((Object)"pen").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
        g.drawArc(xi - radius, this.y - 2 * radius, 2 * radius, 2 * radius, 270, 180);
        g.drawLine(this.x, this.y - 2 * radius, xi, this.y - 2 * radius);
        g.drawArc(this.x - radius, this.y - 2 * radius, 2 * radius, 2 * radius, 90, 180);
    }

    private void ParseLabel(String label, StringBuilder sb, StringBuilder sbo, Engine engine) {
        int i;
        for (i = 0; i < label.length() && label.charAt(i) != '/'; ++i) {
            if (label.charAt(i) == '\\') {
                sb.append(label.charAt(i));
                sb.append(label.charAt(++i));
                continue;
            }
            if (label.charAt(i) == '\"') {
                sb.append(label.charAt(i));
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    sb.append(label.charAt(i));
                    ++i;
                }
                sb.append(label.charAt(i));
                continue;
            }
            if (label.charAt(i) == '<') {
                String symbol = "<";
                int num2 = 1;
                int num3 = 1;
                while (i + num3 < label.length() && label.charAt(i + num3) != '/') {
                    if (label.charAt(i + num3) == '<') {
                        ++num2;
                    } else if (label.charAt(i + num3) == '>') {
                        symbol = symbol + label.charAt(i + num3);
                        if (--num2 == 0) break;
                    }
                    symbol = symbol + label.charAt(i + num3);
                    ++num3;
                }
                String entry = null;
                String lemma = null;
                String category = null;
                String[] features = null;
                RefObject<Object> entryRef = new RefObject<Object>(entry);
                RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
                RefObject<Object> categoryRef = new RefObject<Object>(category);
                RefObject<Object> featuresRef = new RefObject<Object>(features);
                boolean parseLexemeSymbol = Dic.parseLexemeSymbol(symbol, entryRef, lemmaRef, categoryRef, featuresRef, null);
                entry = (String)entryRef.argvalue;
                lemma = (String)lemmaRef.argvalue;
                category = (String)categoryRef.argvalue;
                features = (String[])featuresRef.argvalue;
                if (parseLexemeSymbol) {
                    sb.append(symbol);
                } else {
                    ArrayList<String> infos = Dic.normalizeInformation(category, features, engine.properties);
                    if (infos == null || infos.size() == 0) {
                        sb.append(symbol);
                    } else {
                        if (lemma == null) {
                            lemma = entry;
                        }
                        sb.append("<" + entry + "," + lemma + "," + infos.get(0) + ">");
                        for (int ii = 1; ii < infos.size(); ++ii) {
                            sb.append("\n<" + entry + "," + lemma + "," + infos.get(ii) + ">");
                        }
                    }
                }
                i += num3;
                continue;
            }
            sb.append(label.charAt(i));
        }
        if (i < label.length()) {
            for (int io = i + 1; io < label.length(); ++io) {
                if (label.charAt(io) == '\n' || label.charAt(io) == '\r' || label.charAt(io) == '\t') continue;
                sbo.append(label.charAt(io));
            }
        }
    }

    public Gram compile(Language lan, GramType grmType, ArrayList<String> aVocab, HashMap<String, Integer> hVocab, Engine engine) {
        int inode;
        int totalnbofstates = 0;
        int NbOfNodes = this.label.size();
        if (NbOfNodes == 0) {
            return null;
        }
        ArrayList<Gram> grms = new ArrayList<Gram>();
        for (int inode2 = 0; inode2 < NbOfNodes; ++inode2) {
            String label = this.label.get(inode2);
            if (inode2 == 1 || label.length() == 0 || this.commentNode(inode2) || this.areaNode(inode2)) {
                label = "<E>";
            }
            String labelin = null;
            String labelout = null;
            StringBuilder sb = new StringBuilder();
            StringBuilder sbo = new StringBuilder();
            this.ParseLabel(label, sb, sbo, engine);
            labelin = sb.toString();
            labelout = sbo.toString();
            if (labelout.equals("")) {
                labelout = null;
            }
            Regexp r = labelout != null ? new Regexp(lan, labelin, labelout, grmType, aVocab, hVocab) : new Regexp(lan, label, null, grmType, aVocab, hVocab);
            grms.add(r.Grm);
            if (r.Grm == null) continue;
            totalnbofstates += r.Grm.states.size();
        }
        Gram grm = new Gram(totalnbofstates + 2);
        int[] anchor = new int[NbOfNodes];
        anchor[0] = 2;
        Gram g = (Gram)grms.get(0);
        if (g != null) {
            grm.transfer(g, 2, 0);
        }
        for (inode = 1; inode < NbOfNodes; ++inode) {
            anchor[inode] = grms.get(inode - 1) == null ? anchor[inode - 1] : anchor[inode - 1] + ((Gram)grms.get((int)(inode - 1))).states.size();
            g = (Gram)grms.get(inode);
            if (g == null) continue;
            grm.transfer(g, anchor[inode], inode);
        }
        grm.addTransition(0, 2, 0);
        for (inode = 0; inode < NbOfNodes; ++inode) {
            for (int ichild = 0; ichild < this.child.get(inode).size(); ++ichild) {
                int idest = this.child.get(inode).get(ichild);
                if (idest == 1) {
                    grm.addTransition(anchor[inode] + 1, 1, 0);
                    continue;
                }
                grm.addTransition(anchor[inode] + 1, anchor[idest], 0);
            }
        }
        return grm;
    }

    public void storeDataForSerialization0() {
        this.arrHei = Graph.convertIntegers(this.hei);
        this.arrWid = Graph.convertIntegers(this.wid);
        this.arrLabel = this.label.toArray(new String[this.label.size()]);
        this.arrPosX = Graph.convertIntegers(this.posX);
        this.arrPosY = Graph.convertIntegers(this.posY);
        this.arrChild = new int[this.child.size()][];
        for (int i = 0; i < this.child.size(); ++i) {
            ArrayList<Integer> c = this.child.get(i);
            this.arrChild[i] = Graph.convertIntegers(c);
        }
        this.extraParams = new ArrayList();
    }

    private static StringBuilder convert(StringBuilder intexLabel, GramType gt) {
        StringBuilder res;
        block43: {
            char character;
            int i;
            int iInput;
            StringBuilder input;
            block44: {
                int i2;
                block41: {
                    int i3;
                    block42: {
                        input = new StringBuilder();
                        for (iInput = 0; iInput < intexLabel.length() && intexLabel.charAt(iInput) != '/'; ++iInput) {
                            char character2 = intexLabel.charAt(iInput);
                            if (character2 == '\\') {
                                if (intexLabel.charAt(iInput + 1) != '+') {
                                    input.append(character2);
                                }
                                input.append(intexLabel.charAt(++iInput));
                                continue;
                            }
                            if (character2 == '+') {
                                input.append('\n');
                                continue;
                            }
                            if (character2 == '\"') {
                                input.append(character2);
                                ++iInput;
                                while (iInput < intexLabel.length() && intexLabel.charAt(iInput) != '\"') {
                                    input.append(intexLabel.charAt(iInput));
                                    ++iInput;
                                }
                                if (iInput < intexLabel.length()) {
                                    input.append(intexLabel.charAt(iInput));
                                    continue;
                                }
                                input.append('\"');
                                continue;
                            }
                            if (character2 == '<') {
                                input.append(character2);
                                ++iInput;
                                while (iInput < intexLabel.length() && intexLabel.charAt(iInput) != '>') {
                                    input.append(intexLabel.charAt(iInput));
                                    ++iInput;
                                }
                                if (iInput < intexLabel.length()) {
                                    input.append(intexLabel.charAt(iInput));
                                    continue;
                                }
                                input.append('>');
                                continue;
                            }
                            input.append(character2);
                        }
                        if (gt != GramType.FLX) break block41;
                        if (input.length() <= 0 || input.charAt(0) != ':') break block42;
                        res = input;
                        break block43;
                    }
                    res = new StringBuilder();
                    for (i3 = 0; i3 < input.length(); ++i3) {
                        char character3 = input.charAt(i3);
                        if ("C".equals(Character.valueOf(character3))) {
                            res.append("<R>");
                            continue;
                        }
                        if ("D".equals(Character.valueOf(character3))) {
                            res.append("<D>");
                            continue;
                        }
                        if ("L".equals(Character.valueOf(character3))) {
                            res.append("<B>");
                            continue;
                        }
                        if ("R".equals(Character.valueOf(character3))) {
                            res.append("<R>");
                            continue;
                        }
                        if (Character.isDigit(character3)) {
                            int nb = Character.digit(character3, 36);
                            ++i3;
                            while (i3 < input.length() && Character.isDigit(input.charAt(i3))) {
                                nb *= 10;
                                int helpNb = Character.digit(input.charAt(i3), 36);
                                nb += helpNb;
                                ++i3;
                            }
                            --i3;
                            res.append("<B" + nb + ">");
                            continue;
                        }
                        res.append(input.charAt(i3));
                    }
                    if (iInput >= intexLabel.length()) break block43;
                    res.append('/');
                    i3 = 1;
                    while (iInput + i3 < intexLabel.length() && intexLabel.charAt(iInput + i3) != ':') {
                        if (i3 > 1) {
                            res.append('+');
                        }
                        res.append(intexLabel.charAt(iInput + i3));
                        ++i3;
                    }
                    break block43;
                }
                if (gt != GramType.MORPHO) break block44;
                if (input.length() > 0 && input.charAt(0) == ':') {
                    res = input;
                } else {
                    res = new StringBuilder();
                    for (i2 = 0; i2 < input.length(); ++i2) {
                        if (input.charAt(i2) == '.') {
                            res.append(',');
                            continue;
                        }
                        res.append(input.charAt(i2));
                    }
                }
                if (iInput >= intexLabel.length()) break block43;
                res.append('/');
                i2 = 1;
                while (iInput + i2 < intexLabel.length()) {
                    if (intexLabel.charAt(iInput + i2) == '.') {
                        res.append(',');
                    } else {
                        res.append(intexLabel.charAt(iInput + i2));
                    }
                    ++i2;
                }
                break block43;
            }
            if (input.length() > 0 && input.charAt(0) == ':') {
                res = input;
            } else {
                res = new StringBuilder();
                for (i = 0; i < input.length(); ++i) {
                    character = input.charAt(i);
                    if (character == '.') {
                        res.append(',');
                        continue;
                    }
                    if (character == '\\') {
                        res.append("\\" + input.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    if (character == '<') {
                        if (input.charAt(i + 1) == 'M' && input.charAt(i + 2) == 'O' && input.charAt(i + 3) == 'T' && input.charAt(i + 4) == '>') {
                            res.append("<WF>");
                            i += 4;
                            continue;
                        }
                        if (input.charAt(i + 1) == 'M' && input.charAt(i + 2) == 'I' && input.charAt(i + 3) == 'N' && input.charAt(i + 4) == '>') {
                            res.append("<LOW>");
                            i += 4;
                            continue;
                        }
                        if (input.charAt(i + 1) == 'M' && input.charAt(i + 2) == 'A' && input.charAt(i + 3) == 'J' && input.charAt(i + 4) == '>') {
                            res.append("<UPP>");
                            i += 4;
                            continue;
                        }
                        if (input.charAt(i + 1) == 'P' && input.charAt(i + 2) == 'R' && input.charAt(i + 3) == 'E' && input.charAt(i + 4) == '>') {
                            res.append("<CAP>");
                            i += 4;
                            continue;
                        }
                        if (input.charAt(i + 1) == 'P' && input.charAt(i + 2) == 'N' && input.charAt(i + 3) == 'C' && input.charAt(i + 4) == '>') {
                            res.append("<P>");
                            i += 4;
                            continue;
                        }
                        res.append('<');
                        continue;
                    }
                    res.append(character);
                }
            }
            if (iInput < intexLabel.length()) {
                // empty if block
            }
            res.append('/');
            i = 1;
            while (iInput + i < intexLabel.length()) {
                character = intexLabel.charAt(iInput + i);
                if (character == '.') {
                    res.append(',');
                } else {
                    res.append(character);
                }
                ++i;
            }
        }
        return res;
    }

    private static int[] convertIntegers(ArrayList<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    public static Color convertColor(int n) {
        Color c = new Color(n);
        int r = c.getRed();
        int b = c.getBlue();
        int g = c.getGreen();
        Color c2 = new Color(r, g, b, 255);
        return c2;
    }

    public static long convertColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        long res = b;
        res += (long)g * 256L;
        return res += (long)r * 256L * 256L;
    }

    public int addNode(String lbl, int x, int y) {
        this.label.add(lbl);
        int inode = this.label.size() - 1;
        this.selected.add(false);
        this.posX.add(x);
        this.posY.add(y);
        this.hei.add(-1);
        this.wid.add(-1);
        this.widB.add(-1);
        this.child.add(new ArrayList());
        return inode;
    }

    public void deleteNode(int inode) {
        this.label.remove(inode);
        this.selected.remove(inode);
        this.posX.remove(inode);
        this.posY.remove(inode);
        this.hei.remove(inode);
        this.wid.remove(inode);
        this.widB.remove(inode);
        this.child.set(inode, null);
        this.child.remove(inode);
        for (int i = 0; i < this.child.size(); ++i) {
            ArrayList<Integer> children = this.child.get(i);
            for (int ic = 0; ic < children.size(); ++ic) {
                int dnode = children.get(ic);
                if (dnode == inode) {
                    children.remove(ic);
                    --ic;
                    continue;
                }
                if (dnode <= inode) continue;
                children.set(ic, dnode - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIntex(String fullName, boolean NoojRightToLeft) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(fullName);
            pw.write("#FSGraph 4.0\n");
            pw.write("SIZE " + this.size.width + " " + this.size.height + "\n");
            String fStyle = "";
            if (this.ifont.isBold()) {
                fStyle = "B";
            }
            if (this.ifont.isItalic()) {
                fStyle = fStyle + "I";
            }
            if (fStyle == "") {
                fStyle = " ";
            }
            pw.write("FONT " + this.wholeGrammar.iFontName + ":" + fStyle + " " + this.wholeGrammar.iFontSize + "\n");
            fStyle = "";
            if (this.ofont.isBold()) {
                fStyle = "B";
            }
            if (this.ofont.isItalic()) {
                fStyle = fStyle + "I";
            }
            if (fStyle == "") {
                fStyle = " ";
            }
            pw.write("OFONT " + this.wholeGrammar.oFontName + ":" + fStyle + " " + this.wholeGrammar.oFontSize + "\n");
            long color = Graph.convertColor(this.wholeGrammar.aColor);
            pw.write("ACOLOR " + color + "\n");
            color = Graph.convertColor(this.wholeGrammar.bColor);
            pw.write("BCOLOR " + color + "\n");
            color = Graph.convertColor(this.wholeGrammar.cColor);
            pw.write("CCOLOR " + color + "\n");
            color = Graph.convertColor(this.wholeGrammar.fColor);
            pw.write("FCOLOR " + color + "\n");
            color = Graph.convertColor(this.wholeGrammar.sColor);
            pw.write("SCOLOR " + color + "\n");
            pw.write("DBOXES y\n");
            pw.write("DFRAME " + (this.wholeGrammar.dispFrame ? "y" : "n") + "\n");
            pw.write("DDATE " + (this.wholeGrammar.dispDate ? "y" : "n") + "\n");
            pw.write("DFILE " + (this.wholeGrammar.dispFile ? "y" : "n") + "\n");
            pw.write("DDIR " + (this.wholeGrammar.dispDir ? "y" : "n") + "\n");
            pw.write("DRIG " + (NoojRightToLeft ? "y" : "n") + "\n");
            pw.write("DRST " + (this.wholeGrammar.dispState ? "y" : "n") + "\n");
            pw.write("FITS " + this.fits + "\n");
            pw.write("PORIENT " + (this.size.width > this.size.height ? "L" : "P") + "\n");
            pw.write("#\n");
            pw.write(this.label.size() + "\n");
            for (int iNode = 0; iNode < this.label.size(); ++iNode) {
                pw.write("\"");
                pw.write(this.protectChars(this.label.get(iNode)));
                pw.write("\" ");
                pw.write(this.posX.get(iNode) + " ");
                pw.write(this.posY.get(iNode) + " ");
                ArrayList<Integer> lc = this.child.get(iNode);
                pw.write(lc.size() + " ");
                for (int iChild = 0; iChild < lc.size(); ++iChild) {
                    int c = lc.get(iChild);
                    pw.write(c + " ");
                }
                pw.write("\n");
            }
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream!", 0);
        }
        finally {
            pw.close();
        }
    }

    public void saveCurrentGraphInHistory(String modification) {
        this.history.add(modification);
        this.history.add(this.clone());
        this.iHistory += 2;
    }

    public void purgeHistory() {
        if (this.iHistory >= 2) {
            this.history.subList(0, this.iHistory - 2);
            this.iHistory = 2;
            this.history.set(0, "Initial");
            Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
            this.getGraphFromHistory(cgrf);
            if (this.history.size() > 2) {
                this.history.subList(2, this.history.size());
            }
        } else {
            this.history = new ArrayList();
            this.history.add("Initial");
            this.history.add(this);
            this.iHistory = 2;
        }
    }

    public void undo() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory == 2) {
            return;
        }
        this.iHistory -= 2;
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    public void reset() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory == 2) {
            return;
        }
        this.iHistory = 2;
        Graph cgrf = (Graph)this.history.get(1);
        this.getGraphFromHistory(cgrf);
    }

    public void redo() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory >= this.history.size()) {
            return;
        }
        this.iHistory += 2;
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    public void redoEnd() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory >= this.history.size()) {
            return;
        }
        this.iHistory = this.history.size();
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    public void Do(int ihistory) {
        this.iHistory = ihistory;
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    private void getGraphFromHistory(Graph cgrf) {
        int i;
        this.wholeGrammar = cgrf.wholeGrammar;
        this.hei = new ArrayList();
        for (i = 0; i < cgrf.hei.size(); ++i) {
            this.hei.add(cgrf.hei.get(i));
        }
        this.wid = new ArrayList();
        for (i = 0; i < cgrf.wid.size(); ++i) {
            this.wid.add(cgrf.wid.get(i));
        }
        this.widB = new ArrayList();
        for (i = 0; i < cgrf.wid.size(); ++i) {
            this.widB.add(cgrf.wid.get(i));
        }
        this.label = new ArrayList();
        for (i = 0; i < cgrf.label.size(); ++i) {
            this.label.add(cgrf.label.get(i));
        }
        this.selected = new ArrayList();
        for (i = 0; i < cgrf.selected.size(); ++i) {
            this.selected.add(cgrf.selected.get(i));
        }
        this.posX = new ArrayList();
        for (i = 0; i < cgrf.posX.size(); ++i) {
            this.posX.add(cgrf.posX.get(i));
        }
        this.posY = new ArrayList();
        for (i = 0; i < cgrf.posY.size(); ++i) {
            this.posY.add(cgrf.posY.get(i));
        }
        this.child = new ArrayList();
        for (i = 0; i < cgrf.child.size(); ++i) {
            ArrayList<Integer> children = cgrf.child.get(i);
            ArrayList<Integer> cchildren = new ArrayList<Integer>();
            for (int j = 0; j < children.size(); ++j) {
                cchildren.add(children.get(j));
            }
            this.child.add(cchildren);
        }
    }

    public Graph clone() {
        int i;
        Graph grf = new Graph();
        grf.wholeGrammar = this.wholeGrammar;
        grf.hei = new ArrayList();
        for (i = 0; i < this.hei.size(); ++i) {
            grf.hei.add(this.hei.get(i));
        }
        grf.wid = new ArrayList();
        for (i = 0; i < this.wid.size(); ++i) {
            grf.wid.add(this.wid.get(i));
        }
        grf.widB = new ArrayList();
        for (i = 0; i < this.wid.size(); ++i) {
            grf.widB.add(this.wid.get(i));
        }
        grf.label = new ArrayList();
        for (i = 0; i < this.label.size(); ++i) {
            grf.label.add(this.label.get(i));
        }
        grf.selected = new ArrayList();
        for (i = 0; i < this.selected.size(); ++i) {
            grf.selected.add(this.selected.get(i));
        }
        grf.posX = new ArrayList();
        for (i = 0; i < this.posX.size(); ++i) {
            grf.posX.add(this.posX.get(i));
        }
        grf.posY = new ArrayList();
        for (i = 0; i < this.posY.size(); ++i) {
            grf.posY.add(this.posY.get(i));
        }
        grf.child = new ArrayList();
        for (i = 0; i < this.child.size(); ++i) {
            ArrayList<Integer> children = this.child.get(i);
            ArrayList<Integer> cchildren = new ArrayList<Integer>();
            for (int j = 0; j < children.size(); ++j) {
                cchildren.add(children.get(j));
            }
            grf.child.add(cchildren);
        }
        return grf;
    }

    public static ArrayList<String> embGraphsLabel(String label) {
        String output = null;
        ArrayList<String> embedded = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(label, outputRef);
        output = (String)outputRef.argvalue;
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].length() <= 1 || terms[i].charAt(0) != ':') continue;
            if (embedded == null) {
                embedded = new ArrayList<String>();
            }
            embedded.add(terms[i].substring(1));
        }
        return embedded;
    }

    public static String[] inLineLabel(String label, RefObject<String> output) {
        String input;
        int i;
        for (i = 0; i < label.length() && label.charAt(i) != '/'; ++i) {
            if (label.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (label.charAt(i) == '\"') {
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    ++i;
                }
                continue;
            }
            if (label.charAt(i) != '<') continue;
            ++i;
            while (i < label.length() && label.charAt(i) != '>') {
                ++i;
            }
        }
        if (i > label.length()) {
            input = "ERROR";
            output.argvalue = null;
        } else if (i == label.length()) {
            input = label;
            output.argvalue = null;
        } else {
            input = label.substring(0, i);
            output.argvalue = label.substring(i + 1);
        }
        ArrayList<String> aterms = new ArrayList<String>();
        int iterm = 0;
        while (iterm < input.length()) {
            int len = 0;
            while (iterm + len < input.length() && input.charAt(iterm + len) != '\n') {
                if (input.charAt(iterm + len) == '\\') {
                    len += 2;
                    continue;
                }
                if (input.charAt(iterm + len) == '\"') {
                    ++len;
                    while (iterm + len < input.length() && input.charAt(iterm + len) != '\"') {
                        if (input.charAt(iterm + len) == '\\') {
                            ++len;
                        }
                        ++len;
                    }
                    if (iterm + len >= input.length()) continue;
                    ++len;
                    continue;
                }
                if (input.charAt(iterm + len) == '<') {
                    ++len;
                    while (iterm + len < input.length() && input.charAt(iterm + len) != '>') {
                        if (input.charAt(iterm + len) == '\\') {
                            ++len;
                        }
                        ++len;
                    }
                    if (iterm + len >= input.length()) continue;
                    ++len;
                    continue;
                }
                ++len;
            }
            String cterm = input.substring(iterm, iterm + len);
            String noslash = "";
            for (int ict = 0; ict < cterm.length(); ++ict) {
                if (cterm.charAt(ict) == '\\') continue;
                noslash = noslash + cterm.charAt(ict);
            }
            aterms.add(noslash);
            if ((iterm += len) >= input.length() || input.charAt(iterm) != '\n') continue;
            ++iterm;
        }
        String[] terms = aterms.toArray(new String[aterms.size()]);
        return terms;
    }

    public void paint(JPanel p, Graphics g, boolean moving) {
        File file;
        this.widB = new ArrayList();
        for (int i = 0; i < this.label.size(); ++i) {
            this.widB.add(-1);
        }
        this.aColor = this.wholeGrammar.aColor;
        this.cColor = this.wholeGrammar.cColor;
        this.fColor = this.wholeGrammar.fColor;
        this.vColor = this.wholeGrammar.vColor;
        Graphics2D graphics = (Graphics2D)g;
        p.setBackground(this.wholeGrammar.bColor);
        this.e5 = (int)(5.0f * this.scale);
        this.e10 = (int)(10.0f * this.scale);
        this.e20 = (int)(20.0f * this.scale);
        FontMetrics iMetrics = graphics.getFontMetrics(this.ifont);
        this.interline = iMetrics.getHeight();
        FontMetrics vMetrics = graphics.getFontMetrics(this.vfont);
        this.vinterline = vMetrics.getHeight();
        this.epsilonHei = this.interline / 2;
        this.epsilonwidB = this.epsilonWid = iMetrics.stringWidth("<E>");
        this.pen.put("pen", new PenAttributes(this.wholeGrammar.fColor, 1.0f));
        this.pen.put("penC", new PenAttributes(this.wholeGrammar.fColor, 1.0f));
        this.pen.put("penS", new PenAttributes(this.tColor, 2.0f));
        this.pen.put("penF", new PenAttributes(this.wholeGrammar.fColor, 2.0f));
        this.pen.put("penD", new PenAttributes(this.wholeGrammar.cColor, 1.0f));
        graphics.setColor(this.wholeGrammar.bColor);
        graphics.fillRect(0, 0, (int)((float)this.size.width * this.scale), (int)((float)this.size.height * this.scale));
        if (this.name != "Main") {
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            graphics.drawString(this.name, this.e20, this.e20);
        }
        if (this.wholeGrammar.dispFrame) {
            graphics.setColor((Color)this.pen.get((Object)"penF").color);
            graphics.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            graphics.drawRect(this.e10, this.e10, (int)((float)this.size.width * this.scale) - this.e20, (int)((float)this.size.height * this.scale) - this.e20);
        }
        int line = 2;
        if (this.wholeGrammar.dispDate && this.wholeGrammar.fullName != null && (file = new File(this.wholeGrammar.fullName)).exists()) {
            Date dt = new Date(file.lastModified());
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy, hh:mm:ss");
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            graphics.drawString(dateFormat.format(dt), this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
        }
        if (this.wholeGrammar.dispFile) {
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            if (this.wholeGrammar.fullName != null) {
                if (this.wholeGrammar.dispDir) {
                    graphics.drawString(this.wholeGrammar.fullName, this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
                } else {
                    graphics.drawString(FilenameUtils.removeExtension(new File(this.wholeGrammar.fullName).getName()), this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
                }
            }
        }
        if (this.wholeGrammar.dispGrid) {
            int GridSize;
            for (int i = GridSize = 20; i < this.size.width; i += GridSize) {
                for (int j = GridSize; j < this.size.height; j += GridSize) {
                    graphics.setColor((Color)this.pen.get((Object)"penF").color);
                    graphics.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
                    graphics.drawLine((int)((float)i * this.scale), (int)((float)j * this.scale), i + 1, j + 1);
                }
            }
        }
        int NbOfNodes = this.label.size();
        if (p.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            for (int inode = 0; inode < NbOfNodes; ++inode) {
                if (inode == 1) {
                    this.paintTerminalNode(inode, graphics);
                    continue;
                }
                if (this.variableNode(inode)) {
                    this.paintVariableNode(inode, graphics);
                    continue;
                }
                if (this.commentNode(inode)) {
                    this.paintCommentNode(inode, graphics);
                    continue;
                }
                if (this.areaNode(inode)) {
                    this.paintAreaNode(inode, graphics);
                    continue;
                }
                this.paintRegularNode(inode, graphics);
            }
        } else {
            for (int inode = 0; inode < NbOfNodes; ++inode) {
                if (inode == 1) {
                    this.paintTerminalNode(inode, graphics);
                    continue;
                }
                if (this.variableNode(inode)) {
                    this.paintVariableNode2(inode, graphics);
                    continue;
                }
                if (this.commentNode(inode)) {
                    this.paintCommentNode2(inode, graphics);
                    continue;
                }
                if (this.areaNode(inode)) {
                    this.paintAreaNode(inode, graphics);
                    continue;
                }
                this.paintRegularNode2(inode, graphics);
            }
        }
    }

    private void paintRegularNode2(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.fColor;
        FontMetrics iMetrics = g.getFontMetrics(this.ifont);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        if (terms.length == 1 && terms[0].equals("<E>")) {
            int maxlen = iMetrics.stringWidth("E");
            this.wid.set(inode, maxlen + this.e5);
            this.hei.set(inode, this.interline / 2);
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawLine(this.x, this.y, this.x + maxlen, this.y);
            }
            g.drawLine(this.x - this.e5, this.y, this.x, this.y - this.interline / 2);
            g.drawLine(this.x - this.e5, this.y, this.x, this.y + this.interline / 2);
            g.drawLine(this.x, this.y - this.interline / 2, this.x, this.y + this.interline / 2);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                System.out.println(g.getColor());
                g.drawString(output, this.x, this.y + this.hei.get(inode) * 2);
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
            if (inode == 0) {
                if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                    g.setColor((Color)this.pen.get((Object)"penF").color);
                }
                g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
                g.drawLine(this.x + maxlen, this.y, this.x + maxlen + this.e10, this.y);
            }
        } else {
            this.hei.set(inode, this.interline * terms.length / 2);
            int line0 = this.y - this.hei.get(inode);
            int maxlen = 0;
            for (int i = 0; i < terms.length; ++i) {
                if (terms[i].length() > 0 && terms[i].charAt(0) == ':') {
                    g.setColor(this.aColor);
                    g.fillRect(this.x, line0 + this.interline * i, iMetrics.stringWidth(terms[i].substring(1)), this.interline);
                    g.setFont(this.ifont);
                    g.setColor(b);
                    g.drawString(terms[i].substring(1), this.x, line0 + this.interline * (i + 1));
                    if (iMetrics.stringWidth(terms[i].substring(1)) <= maxlen) continue;
                    maxlen = iMetrics.stringWidth(terms[i].substring(1));
                    continue;
                }
                g.setFont(this.ifont);
                g.setColor(b);
                g.drawString(terms[i], this.x, line0 + this.interline * (i + 1));
                int w = iMetrics.stringWidth(terms[i]);
                if (w <= maxlen) continue;
                maxlen = w;
            }
            this.wid.set(inode, (maxlen += this.e5) + this.e5);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawRect(this.x, line0, maxlen, this.interline * terms.length);
            }
            g.drawLine(this.x - this.e5, this.y, this.x, line0);
            g.drawLine(this.x - this.e5, this.y, this.x, line0 + this.interline * terms.length);
            if (!(inode != 0 || this.inDebugNode != null && this.debugInvisible && inode < this.inDebugNode.size() && this.inDebugNode.get(inode).booleanValue())) {
                g.setColor((Color)this.pen.get((Object)"penF").color);
                g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
                g.drawLine(this.x + maxlen, this.y, this.x + maxlen + this.e10, this.y);
            }
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        for (int i = 0; i < this.child.get(inode).size(); ++i) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
                continue;
            }
            this.drawConnection2(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
        }
    }

    private void drawConnection2(int inode, int ilength, int iheight, int jheight, int jnode, Graphics2D g) {
        int destination;
        if (this.inDebugConnection != null && this.debugInvisible && inode < this.inDebugConnection.size() && jnode == (destination = this.inDebugConnection.get(inode).intValue())) {
            return;
        }
        int xi = this.x - this.e5;
        int yi = this.y;
        int xj = (int)((float)this.posX.get(jnode).intValue() * this.scale) + this.wid.get(jnode) - this.e5;
        if (jnode == 1) {
            xj += this.e5;
        }
        int yj = (int)((float)this.posY.get(jnode).intValue() * this.scale);
        g.setColor((Color)this.pen.get((Object)"penC").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"penC").stroke));
        if (xi >= xj) {
            g.drawLine(xi, yi, xj, yj);
            return;
        }
        if (yi - iheight >= yj + jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi - this.e10, yi - iheight - this.e10), new Point(xj + this.e10, yj + iheight + this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else if (yi + iheight <= yj - jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi - this.e10, yi + iheight + this.e10), new Point(xj + this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi - this.e10, yi - iheight - this.e10), new Point(xj + this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        }
    }

    private void paintVariableNode2(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics vMetrics = g.getFontMetrics(this.vfont);
        String parenthesis = terms[0].substring(1, 2);
        g.setFont(this.vfont);
        g.setColor(this.vColor);
        if (parenthesis.equals("(")) {
            g.drawString(")", this.x, this.y - this.vinterline / 2);
        } else if (parenthesis.equals(")")) {
            g.drawString("(", this.x, this.y - this.vinterline / 2);
        } else {
            g.drawString(terms[0].substring(1, 2), this.x, this.y - this.vinterline / 2);
        }
        if (terms[0].length() > 2) {
            g.setFont(this.ofont);
            g.drawString(terms[0].substring(2), this.x + this.e5, this.y + this.vinterline / 2);
        }
        int maxlen = vMetrics.stringWidth("(");
        this.wid.set(inode, maxlen + this.e5);
        this.widB.set(inode, maxlen + oMetrics.stringWidth(terms[0].substring(2)));
        this.hei.set(inode, this.vinterline / 2);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        if (inode == 0) {
            g.setColor((Color)this.pen.get((Object)"penF").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            g.drawLine(this.x - this.e10, this.y, this.x, this.y);
        }
        for (int i = 0; i < this.child.get(inode).size(); ++i) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
                continue;
            }
            this.drawConnection2(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
        }
    }

    private void paintRegularNode(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.fColor;
        FontMetrics iMetrics = g.getFontMetrics(this.ifont);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        if (terms.length == 1 && terms[0].equals("<E>")) {
            int maxlen = iMetrics.stringWidth("<E>");
            this.wid.set(inode, maxlen + this.e5);
            this.hei.set(inode, this.interline / 2);
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawLine(this.x, this.y, this.x + maxlen, this.y);
            }
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, this.y - this.interline / 2);
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, this.y + this.interline / 2);
            g.drawLine(this.x + maxlen, this.y - this.interline / 2, this.x + maxlen, this.y + this.interline / 2);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                g.drawString(output, this.x, this.y + this.hei.get(inode) * 2);
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.hei.set(inode, this.interline * terms.length / 2);
            int line0 = this.y - this.hei.get(inode);
            int maxlen = 0;
            for (int i = 0; i < terms.length; ++i) {
                int w;
                if (terms[i].length() > 0 && terms[i].charAt(0) == ':') {
                    g.setColor(this.aColor);
                    g.fillRect(this.x, line0 + this.interline * i, iMetrics.stringWidth(terms[i].substring(1)), this.interline);
                    g.setColor(b);
                    g.setFont(this.ifont);
                    g.drawString(terms[i].substring(1), this.x + 3, line0 + this.interline * (i + 1) - 3);
                    if (iMetrics.stringWidth(terms[i].substring(1)) <= maxlen) continue;
                    maxlen = iMetrics.stringWidth(terms[i].substring(1));
                    continue;
                }
                if (terms[i].length() > 0 & terms[i].charAt(0) == '$') {
                    g.setFont(this.ofont);
                    g.setColor(this.vColor);
                    g.drawString(terms[i].substring(1), this.x, line0 + this.interline * i);
                    w = oMetrics.stringWidth(terms[i].substring(1));
                    if (w <= maxlen) continue;
                    maxlen = w;
                    continue;
                }
                g.setFont(this.ifont);
                g.setColor(b);
                g.drawString(terms[i], this.x + 3, line0 + this.interline * (i + 1) - 3);
                w = iMetrics.stringWidth(terms[i]);
                if (w <= maxlen) continue;
                maxlen = w;
            }
            this.wid.set(inode, (maxlen += this.e5) + this.e5);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawRect(this.x, line0, maxlen, this.interline * terms.length);
            }
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, line0);
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, line0 + this.interline * terms.length);
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        if (!(inode != 0 || this.inDebugNode != null && this.debugInvisible && inode < this.inDebugNode.size() && this.inDebugNode.get(inode).booleanValue())) {
            g.setColor((Color)this.pen.get((Object)"penF").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            g.drawLine(this.x - this.e10, this.y, this.x, this.y);
        }
        for (int i = 0; i < this.child.get(inode).size(); ++i) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
                continue;
            }
            this.drawConnection(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
        }
    }

    private void paintAreaNode(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.cColor;
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics cMetrics = g.getFontMetrics(this.cfont);
        if ((int)((float)this.hei.get(inode).intValue() * this.scale) < this.interline * terms.length / 2) {
            this.hei.set(inode, (int)((float)(this.interline * terms.length / 2) / this.scale));
        }
        int h = (int)((float)this.hei.get(inode).intValue() * this.scale);
        int line0 = this.y - (int)((float)this.hei.get(inode).intValue() * this.scale);
        int maxlen = 0;
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].length() <= 0) continue;
            g.setFont(this.cfont);
            g.setColor(b);
            g.drawString(terms[i].substring(1), this.x, line0 + this.interline * (i + 1));
            if (cMetrics.stringWidth(terms[i].substring(1)) <= maxlen) continue;
            maxlen = cMetrics.stringWidth(terms[i].substring(1));
        }
        maxlen += this.e5;
        if (output != null) {
            g.setFont(this.ofont);
            g.setColor(b);
            g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
            if (oMetrics.stringWidth("/" + output) > maxlen) {
                this.widB.set(inode, oMetrics.stringWidth("/" + output));
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.widB.set(inode, maxlen);
        }
        if ((int)((float)this.wid.get(inode).intValue() * this.scale) < this.widB.get(inode)) {
            this.wid.set(inode, (int)((float)this.widB.get(inode).intValue() / this.scale));
        }
        int w = (int)((float)this.wid.get(inode).intValue() * this.scale);
        Rectangle rect = new Rectangle(this.x, line0 + this.interline, w, 2 * (h - this.interline / 2));
        g.setColor((Color)this.pen.get((Object)"penD").color);
        float[] dash1 = new float[]{10.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        g.setStroke(dashed);
        g.draw(rect);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - h - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + h, 10, 10);
            Rectangle rect3 = new Rectangle(this.x + w, this.y - h - 10, 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawLine(this.x + w, this.y + h, this.x + w + 10, this.y + h);
            g.drawLine(this.x + w, this.y + h, this.x + w, this.y + h + 10);
            g.drawLine(this.x + w, this.y + h + 10, this.x + w + 10, this.y + h);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
    }

    private void paintCommentNode(int inode, Graphics2D g) {
        int i;
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.cColor;
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics cMetrics = g.getFontMetrics(this.cfont);
        this.hei.set(inode, this.interline * terms.length / 2);
        int line0 = this.y - this.hei.get(inode);
        int maxlen = 0;
        for (i = 0; i < terms.length; ++i) {
            g.setFont(this.cfont);
            g.setColor(b);
            g.drawString(terms[i], this.x, line0 + this.interline * (i + 1));
            int w = cMetrics.stringWidth(terms[i]);
            if (w <= maxlen) continue;
            maxlen = w;
        }
        this.wid.set(inode, (maxlen += this.e5) + this.e5);
        if (output != null) {
            g.setFont(this.ofont);
            g.setColor(b);
            g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
            if (oMetrics.stringWidth("/" + output) > maxlen) {
                this.widB.set(inode, oMetrics.stringWidth("/" + output));
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.widB.set(inode, maxlen);
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        for (i = 0; i < this.child.get(inode).size(); ++i) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
                continue;
            }
            this.drawConnection(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
        }
    }

    private void paintVariableNode(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics vMetrics = g.getFontMetrics(this.vfont);
        g.setColor(this.vColor);
        g.setFont(this.vfont);
        g.drawString(terms[0].substring(1, 2), this.x, this.y + this.vinterline / 2);
        if (terms[0].length() > 2) {
            g.setFont(this.ofont);
            g.drawString(terms[0].substring(2), this.x + this.e5, this.y + this.vinterline / 2);
        }
        int maxlen = vMetrics.stringWidth("(");
        this.wid.set(inode, maxlen + this.e5);
        this.widB.set(inode, maxlen + oMetrics.stringWidth(terms[0].substring(2)));
        this.hei.set(inode, this.vinterline / 2);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        if (inode == 0) {
            g.setColor((Color)this.pen.get((Object)"penF").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            g.drawLine(this.x - this.e10, this.y, this.x, this.y);
        }
        for (int i = 0; i < this.child.get(inode).size(); ++i) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
                continue;
            }
            this.drawConnection(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
        }
    }

    private void paintCommentNode2(int inode, Graphics2D g) {
        int i;
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.cColor;
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics cMetrics = g.getFontMetrics(this.cfont);
        this.hei.set(inode, this.interline * terms.length / 2);
        int line0 = this.y - this.hei.get(inode);
        int maxlen = 0;
        for (i = 0; i < terms.length; ++i) {
            g.setColor(b);
            g.setFont(this.cfont);
            g.drawString(terms[i], this.x, line0 + this.interline * (i + 1));
            int w = cMetrics.stringWidth(terms[i]);
            if (w <= maxlen) continue;
            maxlen = w;
        }
        this.wid.set(inode, (maxlen += this.e5) + this.e5);
        if (output != null) {
            g.setFont(this.ofont);
            g.setColor(b);
            g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
            if (oMetrics.stringWidth("/" + output) > maxlen) {
                this.widB.set(inode, oMetrics.stringWidth("/" + output));
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.widB.set(inode, maxlen);
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        for (i = 0; i < this.child.get(inode).size(); ++i) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
                continue;
            }
            this.drawConnection2(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
        }
    }

    private void paintTerminalNode(int inode, Graphics2D g) {
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        g.setColor((Color)this.pen.get((Object)"pen").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
        if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
            g.draw(new Ellipse2D.Double(this.x, this.y - this.interline / 2, this.interline, this.interline));
        }
        g.drawLine(this.x, this.y, this.x + this.interline, this.y);
        g.drawLine(this.x + this.interline / 2, this.y - this.interline / 2, this.x + this.interline / 2, this.y + this.interline);
        g.drawLine((int)((float)this.x + (float)this.interline * 0.3f), this.y + this.interline, (int)((float)this.x + (float)this.interline * 0.7f), this.y + this.interline);
        this.hei.set(inode, this.interline / 2);
        this.wid.set(inode, this.interline);
        this.widB.set(inode, -1);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
    }

    public void renameEmbeddedGraphInLabel(int inode, String oldname, String newname) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String lbl = this.label.get(inode);
        String[] terms = Graph.inLineLabel(lbl, outputRef);
        output = (String)outputRef.argvalue;
        boolean modif = false;
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].charAt(0) != ':' || terms[i].substring(1) != oldname) continue;
            terms[i] = ":" + newname;
            modif = true;
        }
        if (modif) {
            this.label.set(inode, this.outLineLabel(terms, output));
        }
    }

    private String outLineLabel(String[] terms, String output) {
        StringBuilder res = new StringBuilder();
        res.append(terms[0]);
        for (int i = 1; i < terms.length; ++i) {
            res.append('\n' + terms[i]);
        }
        return res.toString();
    }

    public void stopDebug() {
        this.inDebugNode = null;
        this.inDebugConnection = null;
    }

    public void setDebug(ArrayList<Object> trace) {
        int i;
        this.inDebugNode = new ArrayList();
        for (i = 0; i < this.selected.size(); ++i) {
            this.inDebugNode.add(false);
        }
        for (i = 0; i < trace.size(); ++i) {
            int iNode;
            if (trace.get(i) instanceof String || (iNode = ((Integer)trace.get(i)).intValue()) == -1) continue;
            this.inDebugNode.set(iNode, true);
        }
        this.inDebugConnection = new ArrayList();
        for (i = 0; i < this.selected.size(); ++i) {
            this.inDebugConnection.add(-1);
        }
        int lastTrace = 0;
        for (int i2 = 0; i2 < trace.size(); ++i2) {
            int iNode;
            if (trace.get(i2) instanceof String || (iNode = ((Integer)trace.get(i2)).intValue()) == -1) continue;
            this.inDebugConnection.set(lastTrace, iNode);
            lastTrace = iNode;
        }
    }

    private String protectChars(String label) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < label.length(); ++i) {
            char characterLabel = label.charAt(i);
            if (characterLabel == '\"') {
                res.append("\\\"");
                continue;
            }
            if (characterLabel == '+') {
                res.append("\\+");
                continue;
            }
            if (characterLabel == '\n') {
                if (i + 1 < label.length() && label.charAt(i + 1) == '/') {
                    res.append("/");
                    ++i;
                    continue;
                }
                res.append("+");
                continue;
            }
            res.append(characterLabel);
        }
        return res.toString();
    }

    private String unProtectChars(StringBuilder label) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < label.length(); ++i) {
            char characterLabel = label.charAt(i);
            if (characterLabel == '+') {
                res.append("\n");
                continue;
            }
            if (characterLabel == '/') {
                res.append("\n/");
                continue;
            }
            if (characterLabel == '\\') {
                if (i + 1 < label.length() && label.charAt(i + 1) == '\"') {
                    res.append("\"");
                    ++i;
                    continue;
                }
                if (i + 1 >= label.length() || label.charAt(i + 1) != '+') continue;
                res.append("+");
                ++i;
                continue;
            }
            res.append(characterLabel);
        }
        return res.toString();
    }

    public void saveONooJGraph(String fullname, BufferedWriter writer) {
        try {
            writer.write("#");
            writer.write(10);
            writer.write(this.name);
            writer.write(10);
            writer.write(Integer.toString(this.label.size()));
            writer.write(10);
            for (int inode = 0; inode < this.label.size(); ++inode) {
                writer.write("\"");
                writer.write(this.protectChars(this.label.get(inode)));
                writer.write("\" ");
                writer.write(this.posX.get(inode).toString() + " ");
                writer.write(this.posY.get(inode).toString() + " ");
                ArrayList<Integer> lc = this.child.get(inode);
                writer.write(Integer.toString(lc.size()) + " ");
                for (int ichild = 0; ichild < lc.size(); ++ichild) {
                    int c = lc.get(ichild);
                    writer.write(Integer.toString(c) + " ");
                }
                writer.write(10);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "ONooJ", 0);
            return;
        }
    }

    public boolean loadONooJ(BufferedReader reader) {
        String line = "";
        try {
            line = reader.readLine();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "ONooJ", 0);
            return false;
        }
        if (line == "" || line.charAt(0) != '#') {
            return false;
        }
        try {
            this.name = line = reader.readLine();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "ONooJ", 0);
            return false;
        }
        try {
            line = reader.readLine();
            int NbOfNodes = Integer.parseInt(line);
            String sep = " ";
            for (int inode = 0; inode < NbOfNodes; ++inode) {
                line = reader.readLine();
                StringBuilder label = new StringBuilder();
                int istrt = 0;
                while (line.charAt(istrt) != '\"') {
                    ++istrt;
                }
                ++istrt;
                int len = 0;
                while (istrt + len < line.length() && line.charAt(istrt + len) != '\"') {
                    if (line.charAt(istrt + len) == '\\') {
                        label.append('\\');
                        label.append(line.charAt(istrt + len + 1));
                        len += 2;
                        continue;
                    }
                    label.append(line.charAt(istrt + len));
                    ++len;
                }
                if (istrt + len >= line.length()) {
                    return false;
                }
                this.label.add(this.unProtectChars(label));
                ++len;
                this.selected.add(false);
                while (Character.isWhitespace(line.charAt(istrt + len))) {
                    ++len;
                }
                String connections = line.substring(istrt + len);
                String[] fields = connections.split(sep);
                int x = 0;
                int y = 0;
                int n = 0;
                try {
                    x = Integer.parseInt(fields[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    y = Integer.parseInt(fields[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n = Integer.parseInt(fields[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.posX.add(x);
                this.posY.add(y);
                this.hei.add(-1);
                this.wid.add(-1);
                this.widB.add(-1);
                int NbOfChildren = n;
                this.child.add(new ArrayList());
                for (int ichild = 0; ichild < NbOfChildren; ++ichild) {
                    n = 0;
                    try {
                        n = Integer.parseInt(fields[ichild + 3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.child.get(inode).add(n);
                }
            }
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "ONooJ", 0);
            return false;
        }
        return true;
    }
}

